#ifndef _LIB_PREFS_H_
#define _LIB_PREFS_H_

#include "c4d_library.h"
#include "c4d_basecontainer.h"
#include "c4d_gui.h"



class CDialog;
class SubDialog;

// public stuff
struct PrefsDialogHook
{
	void *thisptr;

	CDialog *(*SubDialog_Alloc    )(PrefsDialogHook *thi,void *&userdata);
	void    (*SubDialog_Free      )(PrefsDialogHook *thi,void *userdata);
	void		(*SubDialog_EditStart )(PrefsDialogHook *thi,void *userdata,BaseContainer *bc);
	void		(*SubDialog_EditApply	)(PrefsDialogHook *thi,void *userdata,const BaseContainer &originaldata);
	void		(*SubDialog_EditUndo	)(PrefsDialogHook *thi,void *userdata,const BaseContainer &originaldata);
};

// a class for convenience, DO NOT STORE STATIC !!!
class PrefsDialogHookClass
{
		PrefsDialogHook hook;
		BaseContainer *worldedit;

	public:

		PrefsDialogHookClass();

		Bool Register(LONG id,const String &name,LONG parentid=0, LONG sortid=0);
		BaseContainer *GetData();

		// overloadable functions
		virtual SubDialog *Alloc();
		virtual void Free(SubDialog *dlg);
		virtual void EditStart(SubDialog *dlg,BaseContainer *worldedit);
		virtual void EditApply(SubDialog *dlg,const BaseContainer &originaldata);
		virtual void EditUndo(SubDialog *dlg,const BaseContainer &originaldata);
};

class PrefsDlg_Base : public SubDialog 
{
	protected:
		LONG page;
		PrefsDialogHookClass *hook;

	public:

		PrefsDlg_Base(LONG t_page,PrefsDialogHookClass *t_hook)
		{
			page = t_page;
			hook = t_hook;
		}

		virtual Bool CreateLayout(void)
		{
			if (!LoadDialogResource(page,NULL,BFH_SCALEFIT|BFV_SCALEFIT)) return FALSE;
			return TRUE;
		}

		virtual Bool InitValues(void)
		{
			BaseContainer *data = hook->GetData();
			if (!data) return TRUE;
			SetValues(data);
			EnableValues(data);
			return SubDialog::InitValues();
		}

		virtual Bool Command(LONG id,const BaseContainer &msg);

		virtual void SetValues(BaseContainer *data)
		{
		}

		virtual void EnableValues(BaseContainer *data)
		{
		}

		virtual LONG CommandValues(LONG id,const BaseContainer &msg,BaseContainer *data)
		{
			return 0;
		}
};

// public class



// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#define LIBRARY_PREFS					1000466

struct PrefsLib : public C4DLibrary
{
	Bool    (*PrefsLib_Register   )(LONG id,const String *str,PrefsDialogHook *prefsdialoghook,LONG parentid, LONG sortid);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif
